% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trace.R
\name{trace}
\alias{trace}
\title{Tensor Contraction}
\usage{
trace(x, i = NULL, drop = TRUE)
}
\arguments{
\item{x}{array.}

\item{i}{subset of repeated indices to sum up. If \code{NULL}, the tensor contraction takes place on all repeated indices of \code{x}.}

\item{drop}{logical. Drop summation indices? If \code{FALSE}, keep dummy dimensions.}
}
\value{
array.
}
\description{
Sums over repeated indices in a tensor. Can be seen as a generalization of the trace.
}
\examples{
# trace of numeric matrix
x <- matrix(1:4, nrow = 2)
trace(x)

# trace of character matrix
x <- matrix(letters[1:4], nrow = 2)
trace(x)

# trace of a tensor (sum over diagonals)
x <- array(1:27, dim = c(3,3,3))
trace(x)

# tensor contraction over repeated indices
x <- array(1:27, dim = c(3,3,3))
index(x) <- c('i','i','j')
trace(x)

# tensor contraction over specific indices only
x <- array(1:16, dim = c(2,2,2,2))
index(x) <- c('i','i','k','k')
trace(x, i = 'k')

# tensor contraction keeping dummy dimensions
x <- array(letters[1:16], dim = c(2,2,2,2))
index(x) <- c('i','i','k','k')
trace(x, drop = FALSE)

}
\seealso{
\code{\link{index}}, \code{\link{einstein}}
}
