% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{\%diff\%}
\alias{\%diff\%}
\title{Numerical and Symbolic Difference}
\usage{
x \%diff\% y
}
\arguments{
\item{x}{\code{numeric} or \code{character} array.}

\item{y}{\code{numeric} or \code{character} array.}
}
\value{
\code{array}.
}
\description{
Elementwise difference of \code{numeric} or \code{character} arrays.
}
\examples{
### vector 
x <- c("a+1","b+2")
x \%diff\% x

### matrix 
x <- matrix(letters[1:4], ncol = 2)
x \%diff\% x

### array
x <- array(letters[1:12], dim = c(2,2,3))
y <- array(1:12, dim = c(2,2,3))
x \%diff\% y

}
\references{
Guidotti, E. (2020). "calculus: High dimensional numerical and symbolic calculus in R". \url{https://arxiv.org/abs/2101.00086}
}
\seealso{
Other basic arithmetic: 
\code{\link{\%div\%}()},
\code{\link{\%dot\%}()},
\code{\link{\%inner\%}()},
\code{\link{\%kronecker\%}()},
\code{\link{\%outer\%}()},
\code{\link{\%prod\%}()},
\code{\link{\%sum\%}()}
}
\concept{basic arithmetic}
