% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_percentile_map.R
\name{get_percentile_map}
\alias{get_percentile_map}
\title{get_percentile_map}
\usage{
get_percentile_map(r, probs)
}
\arguments{
\item{r}{Raster* object (either RasterStack or RasterBrick). This could be the
full record of daily indices or daily climatology.}

\item{probs}{numeric vector of probabilities with values in the range [0, 1]
listing which percentiles should be calculated.}
}
\value{
list containing all the generated percentile maps
}
\description{
This function calculates percentile(s) at each grid point.
Wrappers raster::calc.
}
\examples{
\dontrun{
 # Generate dummy RasterLayer
 r <- raster(nrows = 2, ncols = 2, xmn = 0, xmx = 360, ymn = -90, ymx = 90, vals = 30)
 # Generate dummy RasterBrick
 b <- raster::brick(lapply(1:(365 * 3),
                    function(i) raster::setValues(r,
                      runif(n = raster::ncell(r), min = 0, max = 100))))
 # Get percentile maps
 get_percentile_map(b, probs = c(0.50, 0.75, 0.90, 0.99))
}

}
