% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcmd.R
\name{rcmd_safe}
\alias{rcmd_safe}
\title{Call R CMD <command> safely}
\usage{
rcmd_safe(cmd, cmdargs = character(), libpath = .libPaths(),
  repos = c(getOption("repos"), c(CRAN = "https://cran.rstudio.com")),
  system_profile = FALSE, user_profile = FALSE, env = c(CYGWIN =
  "nodosfilewarning", R_TESTS = "", R_BROWSER = "false", R_PDFVIEWER = "false"),
  ...)
}
\arguments{
\item{cmd}{Command to run. See \code{R --help} from the command
line for the various commands. In the current version of R (3.2.4)
these are: BATCH, COMPILE, SHLIB, INSTALL, REMOVE, build, check,
LINK, Rprof, Rdconv, Rd2pdf, Rd2txt, Stangle, Sweave, Rdiff, config,
javareconf, rtags.}

\item{cmdargs}{Command line arguments.}

\item{libpath}{The library path.}

\item{repos}{The \sQuote{repos} option. If \code{NULL}, then no
\code{repos} option is set. This options is only used if
\code{user_profile} or \code{system_profile} is set to \code{FALSE},
as it is set using the system or the user profile.}

\item{system_profile}{Whether to use the system profile file.}

\item{user_profile}{Whether to use the user's profile file.}

\item{env}{Environment variables to set for the child process.}

\item{...}{Additional arguments are passed to \code{\link{rcmd}}.}
}
\description{
Very similar to \code{\link{rcmd}}, but with different defaults,
that tend to create a less error-prone execution environment for the
child process.
}
\seealso{
Other R CMD commands: \code{\link{rcmd}}
}

