% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/census_regions.R
\name{list_census_regions}
\alias{list_census_regions}
\title{Query the CensusMapper API for available regions in a given dataset.}
\usage{
list_census_regions(dataset, use_cache = TRUE, quiet = FALSE)
}
\arguments{
\item{dataset}{The dataset to query for available regions, e.g.
\code{"CA16"}.}

\item{use_cache}{If set to TRUE (the default), data will be read from a local cache
that is maintained for the duration of the R session, if
available. If set to FALSE, query the API for the data, and
refresh the local cache with the result.}

\item{quiet}{When TRUE, suppress messages and warnings.}
}
\value{
Returns a data frame with the following columns:

\describe{
  \item{\code{region}}{The region identifier.}

  \item{\code{name}}{The name of that region.}

  \item{\code{level}}{The census aggregation level of that region.}

  \item{\code{pop}}{The population of that region.}

  \item{\code{municipal_status}}{Additional identifiers to distinguish the
    municipal status of census subdivisions.}

  \item{\code{CMA_UID}}{The identifier for the Census Metropolitan Area the region is in (if any).}

  \item{\code{CD_UID}}{The identifier for the Census District the region is in (if any).}

  \item{\code{PR_UID}}{The identifier for the Province the region is in (if unique).}
}
}
\description{
Query the CensusMapper API for available regions in a given dataset.
}
\examples{
list_census_regions('CA16')
}
