% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cansim.R
\name{get_cansim_ndm}
\alias{get_cansim_ndm}
\title{Retrieve a Statistics Canada data table using NDM catalogue number}
\usage{
get_cansim_ndm(cansimTableNumber, language = "english",
  refresh = FALSE, timeout = 200)
}
\arguments{
\item{cansimTableNumber}{the NDM table number to load}

\item{language}{\code{"en"} or \code{"english"} for English and \code{"fr"} or \code{"french"} for French language versions (defaults to English)}

\item{refresh}{(Optional) When set to \code{TRUE}, forces a reload of data table (default is \code{FALSE})}

\item{timeout}{(Optional) Timeout in seconds for downloading cansim table to work around scenarios where StatCan servers drop the network connection.}
}
\value{
tibble format data table output
}
\description{
Retrieves a data table using an NDM catalogue number as a tidy data frame. Retrieved table data is cached for the duration of the current R session only by default.
}
\examples{
get_cansim("34-10-0013")

}
