% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrv_modeling.R
\name{ggerror}
\alias{ggerror}
\title{Plotting Error of Models}
\usage{
ggerror(model)
}
\arguments{
\item{model}{Model to be analyzed. The function will detect what type of
family the model is (e.g. linear = "gaussian", logistic = "binomial") and
plot the appropriate type of model.}
}
\value{
Returns a ggplot object of geom type, other layers can be added on as
seen in example.
}
\description{
Creates a ggplot geom that can be extended and accept other
ggplot layers. Shows residual error from the regression mean for different
types of regression models.
}
\details{
Generate residuals for models. Currently accepts only linear models.
Does not account for covariates yet, although may be able to do this in the
future.
}
\examples{
data("twins")
model <- lm(beck_total ~ HR, data = subset(twins, hour == 7))
ggerror(model)
}
