% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrv_modeling.R
\name{hrv_linear_model}
\alias{hrv_linear_model}
\title{HRV Linear Modeling}
\usage{
hrv_linear_model(data, covar, hrv, prop.weight = FALSE)
}
\arguments{
\item{data}{Data frame that contains all covariates and outcomes. First
column should be ID}

\item{covar}{Vector names of the covariates, with first covariate being the
primary exposure variable for linear regression}

\item{hrv}{Vector names of the HRV measures, contained in \code{data}, that should
be used. Can be generalized to any dependent variable set.}

\item{prop.weight}{This is a logical value if propensity weighting should be
done instead of traditional covariate adjustment. This calls for the
propensity weighting function defined by
\link[card:recurrent_propensity]{card::recurrent_propensity} that will generate both a PROP_SCORE
column and PROP_WEIGHT column. Defaults to FALSE}
}
\value{
List of models with names
}
\description{
\code{hrv_linear_model} Linear models for each HRV measure.
}
\details{
Linear models built with dependent variable being the HRV measures
(e.g. HF, LF, SDNN, etc). Allows for covariates to be included as
available.
}
