% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_categorical.survey.design.R
\name{.process_nested_list_as_df}
\alias{.process_nested_list_as_df}
\title{Convert Nested Lists to Column}
\usage{
.process_nested_list_as_df(x, arg, new_column, unlist = FALSE)
}
\arguments{
\item{x}{(\code{data.frame})\cr
result data frame}

\item{arg}{(\code{list})\cr
the nested list}

\item{new_column}{(\code{string})\cr
new column name}

\item{unlist}{(\code{logical})\cr
whether to fully unlist final results}
}
\value{
a data frame
}
\description{
Some arguments, such as \code{stat_label}, are passed as nested lists. This
function properly unnests these lists and adds them to the results data frame.
}
\examples{
ard <- ard_categorical(cards::ADSL, by = "ARM", variables = "AGEGR1")

cardx:::.process_nested_list_as_df(ard, NULL, "new_col")
}
\keyword{internal}
