% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_stats_aov.R
\name{ard_stats_aov}
\alias{ard_stats_aov}
\title{ARD ANOVA}
\usage{
ard_stats_aov(formula, data, ...)
}
\arguments{
\item{formula}{A formula specifying the model.}

\item{data}{A data frame in which the variables specified in the
    formula will be found. If missing, the variables are searched for in
    the standard way.}

\item{...}{arguments passed to \code{stats::aov(...)}}
}
\value{
ARD data frame
}
\description{
Analysis results data for Analysis of Variance.
Calculated with \code{stats::aov()}
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = c("broom.helpers", "parameters")))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ard_stats_aov(AGE ~ ARM, data = cards::ADSL)
\dontshow{\}) # examplesIf}
}
