% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuel_and_co2.R
\name{fuel_cons_harvester_2}
\alias{fuel_cons_harvester_2}
\title{Fuel Consumption of a Harvester per Cubic Meter Harvested Wood (Version #2)}
\usage{
fuel_cons_harvester_2(tree_vol, harvest_vol_ha, thinning = TRUE)
}
\arguments{
\item{tree_vol}{Average standing merchandable wood volume over bark (m³) per
harvested tree}

\item{harvest_vol_ha}{Harvested merchandable wood volume over bark per ha
(m³/ha)}

\item{thinning}{Logical, TRUE (default) if the harvest is a thinning, or
another kind of felling operation (FALSE)}
}
\value{
Fuel consumption of a harvester in liters diesel fuel per m³
harvested wood
}
\description{
Fuel consumption of a harvester in liters diesel per m³ havested wood after
\insertCite{karha_et_al_2023;textual}{care4cmodel}.
}
\examples{
  tree_vol    <- c(0.03,  0.10,  1.00,  2.00,  5.00)
  harvest_vol <- c(5.00, 10.00, 50.00, 25.00, 10.00)

  fuel_cons_harvester_2(tree_vol, harvest_vol, TRUE)
  fuel_cons_harvester_2(tree_vol, harvest_vol, FALSE)

}
\references{
\insertRef{karha_et_al_2023}{care4cmodel}
}
