% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/optAUC.R
\name{safeOptAUC}
\alias{safeOptAUC}
\title{Safe optimization of the AUC}
\usage{
safeOptAUC(X, Y, iter = 100L)
}
\arguments{
\item{X}{the matrix of predictors}

\item{Y}{the dependent variable}

\item{iter}{an integer for the number of iterations}
}
\value{
A numeric of the weights for each model
}
\description{
This algorithm optimizes the AUC for regression models to avoid ensembling
where the ensembled model fits worse than any component model
}
\details{
This optimizer uses a stopping criterion that if the optimized model
has an AUC that is worse than any individual model, it continues optimizing
until this is no longer the case. If it fails to surpass any component model
it issues a warning and weights the best model 1 and all other models 0.
}
\examples{
x <- matrix(runif(10), ncol=2)
y <- sample(c('Y', 'N'), 5, replace=TRUE)
safeOptAUC(x, y, iter = 2L)
}

