#' @title Cartography Package
#' @name cartography
#' @description 
#' The cartography package allows various cartographic representations 
#' such as proportional symbols, chroropleth, typology, flows or discontinuities. 
#' In addition it also proposes some useful features like cartographic palettes, 
#' layout (scale, north arrow, title…), labels, legends or access to cartographic 
#' API to ease the graphic presentation of maps.
#' 
#' A vignette contains commented scripts on how to build various types of maps 
#' with \code{cartography}: \cr
#' \code{vignette(topic = "cartography")}
#' 
#' Main functions : 
#' \itemize{
#' \item{Proportional symbols maps (circles, squares, bars)\cr 
#' \link{propSymbolsLayer}, \link{propSymbolsChoroLayer}, 
#' \link{propSymbolsTypoLayer}, \link{propTrianglesLayer}}
#' \item{Chroropleth maps (main discretization methods are available)\cr
#' \link{choroLayer}}
#' \item{Typology maps\cr
#' \link{typoLayer}}
#' \item{Flow maps (proportional and classified links)\cr
#' \link{getLinkLayer}, \link{propLinkLayer}, \link{gradLinkLayer}}
#' \item{Discontinuities maps (variable size and color of borders)\cr
#' \link{getBorders}, \link{discLayer}}
#' \item{Cartographic palettes (palettes adapted to cartographic representation)\cr
#' \link{carto.pal}}
#' \item{Layout (scale, north arrow, title...)\cr
#' \link{layoutLayer}}
#' \item{Labels\cr
#' \link{labelLayer}}
#' \item{Legends \cr
#' \link{legendBarsSymbols},
#' \link{legendChoro}, \link{legendCirclesSymbols}, \link{legendGradLines}, 
#' \link{legendPropLines}, \link{legendPropTriangles}, 
#' \link{legendSquaresSymbols}, \link{legendTypo}
#' }
#' \item{Access to cartographic API (via rosm package)\cr
#' \link{getTiles}, \link{tilesLayer}
#' }
#' \item{Irregular polygons to regular grid transformation with data handling\cr
#' \link{getGridLayer}, \link{getGridData}}
#' }
#' 
#' @docType package
NULL
