% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.R
\name{text}
\alias{text}
\title{Text}
\usage{
text(
  x,
  color = NULL,
  align = NULL,
  spacing = NULL,
  decoration = NULL,
  wrap = NULL,
  select = NULL
)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{color}{One of \code{"blue"}, \code{"indigo"}, \code{"purple"}, \code{"red"}, \code{"orange"}, \code{"yellow"}, \code{"green"}, \code{"teal"}, \code{"cyan"}, \code{"black-50"}, \code{"white-50"}, \code{"white"}, \code{"muted"}, \code{"body"}, or \code{"reset"} specifying the text
color, defaults to \code{NULL}, in which case the argument is ignored.}

\item{align}{One of \code{"left"}, \code{"right"}, or \code{"center"} specifying the alignment
of the text within the element, defaults to \code{NULL}, in which case the
argument is ignored.}

\item{spacing}{One of \code{"sm"}, \code{"small"}, \code{"md"}, \code{"medium"}, \code{"lg"}, or \code{"large"} specifying the text
line spacing, defaults to \code{NULL}, in which case the argument is ignored.}

\item{decoration}{One of \code{"none"}, \code{"underline"}, or \code{"strikethrough"} specifying how
the text is decorated, defaults to \code{NULL}, in which case the argument is
ignored.}

\item{wrap}{One of \code{TRUE} or \code{FALSE} specifying if an element's text should
wrap onto new lines, defaults to \code{NULL}, in which case the argument
is ignored.}

\item{select}{One of \code{"all"} or \code{"none"} specifying how the element's
text is selected when the user clicks on the element, defaults to \code{NULL},
in which case the argument is ignored.}
}
\description{
The \code{text()} function adjusts the text color, alignment, line spacing, line
wrapping, line height, and decoration of a tag element.
}
\section{Colors}{
\if{html}{\out{<div class="r">}}\preformatted{div(
  .style \%>\%
    text("blue") \%>\%  # <-
    border("blue"),
  p("Nullam tristique diam non turpis.",
    "Pellentesque dapibus suscipit ligula.",
    "Nullam eu ante vel est convallis dignissim."),
  p("Aliquam posuere.")
)
}\if{html}{\out{</div>}}\if{html}{\out{
<!--html_preserve-->
}}
\if{html}{\out{
<div class="cas-text-blue cas-border cas-border-blue cas-border-round-md">
}}
\if{html}{\out{
<p>
}}


Nullam tristique diam non turpis. Pellentesque dapibus suscipit ligula.
Nullam eu ante vel est convallis dignissim.\if{html}{\out{
</p>
}}
\if{html}{\out{
<p>
}}


Aliquam posuere.\if{html}{\out{
</p>
}}
\if{html}{\out{
</div>
}}
\if{html}{\out{
<!--/html_preserve-->
}}
}

\examples{

library(htmltools)

div(
  .style \%>\%
    text(spacing = "small"),
  "Nam vestibulum accumsan nisl.",
  "Fusce commodo."
)

div(
  .style \%>\%
    text(spacing = "large"),
  "Suspendisse potenti.",
  "Pellentesque tristique imperdiet tortor."
)

tags$button(
  .style \%>\%
    text(wrap = FALSE),
  "Aliquam feugiat tellus ut neque."
)

}
