% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_selector.R
\name{item_selector}
\alias{item_selector}
\title{Linear programming solver}
\usage{
item_selector(E_mat, D, C, minmax)
}
\arguments{
\item{E_mat}{matrix of the associated value of every item allocated to
every level node. Rows represent items and columns represent level nodes.
The "associated value" can be the MSE if the selection criterium is "MEPV",
the FI if the selection criterium is "MFI" and ****}

\item{D}{vector of confluencies of every level node}

\item{C}{vector of item capacities}

\item{minmax}{optimisation direction. Options: \code{TRUE} to maximise and
\code{FALSE} to minimise}
}
\value{
A matrix of exposure rates. Rows represent items and columns
represent level nodes. Every item with a positive exposure rate for a level
node is allocated to that node
}
\description{
Computes the exposure rate of every item allocated to every level node. If
more than one item is allocated to the same level node, the node splits.
}
\author{
Javier Rodríguez-Cuadrado
}
