% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CAT_ability_est.R
\name{predict.cat.dt}
\alias{predict.cat.dt}
\title{Predict S3 method for \code{cat.dt}}
\usage{
\method{predict}{cat.dt}(object, res, ...)
}
\arguments{
\item{object}{A \code{cat.dt} object returned by \code{\link{CAT_DT}}.}

\item{res}{Vector containing the test taker's responses to every item}

\item{...}{Not used}
}
\value{
A list containing the following elements:

\code{$estimation} Estimated ability level after each level of the tree.

\code{$linf} Lower limit of the final estimation at 95%

\code{$lsup} Upper limit of the final estimation at 95%

\code{$items} Administered item in each level.

\code{$graphics} Plot object of the evolution of the ability level
estimation. It shows the ability level estimation after the individual
has answered to every administered item.
}
\description{
Predict S3 method for \code{cat.dt}
}
\author{
Javier Rodríguez-Cuadrado
}
