% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cata.R
\encoding{UTF-8}
\name{bcluster}
\alias{bcluster}
\title{Wrapper function for b-cluster analysis}
\usage{
bcluster(X, inspect = TRUE, inspect.plot = TRUE, algorithm = "n", 
measure = "b", G = NULL, M = NULL, max.iter = 500, tol = exp(-8), 
runs = 1, seed = 2021, verbose = FALSE)
}
\arguments{
\item{X}{three-way array with \code{I} assessors, \code{J} products, 
\code{M} attributes where CATA data have values \code{0} (not checked) and 
\code{1} (checked)}

\item{inspect}{default (\code{TRUE}) calls the \code{\link[cata]{inspect}}
function to evaluate all solutions (when \code{runs>1})}

\item{inspect.plot}{default (\code{TRUE}) plots results from the 
\code{\link[cata]{inspect}} function}

\item{algorithm}{default is \code{n} for non-hierarchical; \code{h} for 
hierarchical}

\item{measure}{default is \code{b} for the \code{b}-measure; \code{Q} for 
Cochran's Q test}

\item{G}{number of clusters (required for non-hierarchical algorithm)}

\item{M}{initial cluster memberships}

\item{max.iter}{maximum number of iteration allowed (default \code{500})}

\item{tol}{non-hierarchical algorithm stops if variance over 5 iterations is
less than \code{tol} (default: \code{e^{-8}})}

\item{runs}{number of runs (defaults to \code{1})}

\item{seed}{for reproducibility (default is \code{2021})}

\item{verbose}{maximum number of iterations}
}
\value{
list with elements:
\itemize{
\item{\code{runs} : b-cluster analysis results from 
\code{\link[cata]{bcluster.n}} or \code{\link[cata]{bcluster.h}} 
(in a list if \code{runs>1})}
\item{\code{inspect} : result from \code{\link[cata]{inspect}} (the plot from 
this function is rendered if \code{inspect.plot} is \code{TRUE})}}
}
\description{
By default, \code{bcluster} calls a function to perform b-cluster analysis 
by a non-hierarchical iterative ascent algorithm,
then inspects results if there are multiple runs.
}
\examples{
data(bread)

# b-cluster analysis on the first 14 consumers and the first 6 attributes
(b1 <- bcluster(bread$cata[1:14,,1:6], G=2))
# identical to: 
# (b2 <- bcluster.n(bread$cata[1:10,,1:6], G=2))
}
\references{
Castura, J.C., Meyners, M., Varela, P., & Næs, T. (2021). 
Clustering consumers based on product discrimination in check-all-that-apply 
(CATA) data. \emph{Food Quality and Preference}, submitted.
}
