% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cata.R
\encoding{UTF-8}
\name{getb}
\alias{getb}
\title{Calculate the b-measure}
\usage{
getb(X.b, X.c)
}
\arguments{
\item{X.b}{three-way (\code{I, J(J-1)/2, M}) array with 
\code{I} assessors, \code{J(J-1)/2} product comparisons, \code{M} CATA 
attributes, where values are counts of type \code{b} from the function 
\code{\link[cata]{barray}})}

\item{X.c}{array of same dimension as \code{X.b}, where values are counts of 
type \code{b} from the function \code{\link[cata]{barray}})}
}
\value{
b-measure
}
\description{
Function to calculate the b-measure, which quantifies the sensory 
differentiation retained.
}
\examples{
data(bread)

bread.bc <- barray(bread$cata)
getb(bread.bc[1:10,,1,], bread.bc[1:10,,2,])
}
\references{
Castura, J.C., Meyners, M., Varela, P., & Næs, T. (2021). 
Clustering consumers based on product discrimination in check-all-that-apply 
(CATA) data. \emph{Food Quality and Preference}, submitted.
}
