% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code.R
\name{warn_now}
\alias{warn_now}
\alias{addLF_message}
\title{Custom functions to display signals (experimental)}
\usage{
warn_now(...)

addLF_message(...)
}
\arguments{
\item{\dots}{An S3 condition object or whatever values one wants to pass into the original \code{warning} or \code{message} functions}
}
\description{
\code{R} has "issues" signalling pre-made message and warning conditions: when you pass
these objects to \code{\link{warning}} or \code{\link{message}}, they
ignore all the additional arguments, so you can't use, say, \code{immediate. = TRUE} or
\code{appendLF = TRUE}. These two functions take care of those problems, respectively. These
functions are probably best let be and are more "experimental" in many senses,
but they have been exported in case the user wants to make code similar to the other
functions in this package. \cr \cr
\code{warn_now}: The function \code{\link{warning}} lets you immediately output warnings with
\code{immediate.=TRUE}, but not if the input is already a condition
object (weird, I know). This function is a modified Frankenstein mashup
of \code{warning} and \code{message} that will immediately output warnings regardless
of the form of the input (as well as appending a newline character). The downside is that no other additional arguments can be used, but I can't
seem to do anything about that at the moment. This is used primarily for
\code{\link{raise_conditions}} and \code{\link{raise_col_warnings}}. \cr \cr
\code{addLF_message}: The function \code{\link{message}} lets you automatically append a newline to
a message that you signal, regardless of its form. It suffers from the same argument
restrictions as \code{warn_now}.
}
