% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trace.R
\name{add_catmaply_slider}
\alias{add_catmaply_slider}
\title{Add catmaply slider traces}
\usage{
add_catmaply_slider(
  fig,
  df,
  annotated,
  text_color = "#444",
  text_size = 12,
  text_font_family = c("Open Sans", "verdana", "arial", "sans-serif"),
  slider_steps,
  slider_currentvalue_prefix = "",
  slider_step_visible,
  slider_currentvalue_visible,
  slider_tick_visible,
  hover_hide,
  color_palette,
  categorical_color_range,
  category_items,
  legend_items,
  legend
)
}
\arguments{
\item{fig}{plotly object}

\item{df}{data.frame or tibble holding the data.}

\item{annotated}{boolean indicating if annotations should be displayed.}

\item{text_color}{font color to be used for text; (default: "#444").}

\item{text_size}{font size to be used for text/annotation. Needs to be a number greater than or equal to 1; (default: 12).
The web browser will only be able to apply a font if it is available on the system which it operates.
Provide multiple font families, separated by commas, to indicate the preference in which to apply fonts if they aren't available on the system;
(default: c("Open Sans", "verdana", "arial", "sans-serif")).}

\item{slider_steps}{list holding the configuration of the steps to be created. There are two alternatives: \code{auto} and
\code{custom}; whereas the \code{auto} mode creates the steps automatically and \code{custom} takes custom instructions on how to create the steps.
For mode \code{auto}, a \code{list} with the following elements has to be submitted (values of the list element are just examples): \cr
list( \cr
  slider_start=1, \cr
  slider_range=15, \cr
  slider_shift=5, \cr
) \cr
This will create the steps automatically for you, essentially starting at position \code{slider_start},
shifting the window of size \code{slider_range} along the x axis with a stepsize of \code{slider_shift}. The stepnames
are automatically selected with the x value of the left side of the slider_range (so for 1 it would take the first value of the x axis as name of the step). \cr
With custom, on the other hand, you can define the step configuration without any restrictions. The custom
configuration needs to be defined in a \code{list} with the following elements. \cr
list( \cr
  list(name="Step_One", range=c(1, 50)), \cr
  list(name="Step_Two", range=c(5, 55)), \cr
  ... \cr
). \cr
(default: \cr
list( \cr
  slider_start=1, \cr
  slider_range=15, \cr
  slider_shift=5, \cr
)).}

\item{slider_currentvalue_prefix}{prefix to be used for the slider title. Only used if \code{slider=TRUE}. (default: "").}

\item{slider_step_visible}{boolean indicating if the step names should be displayed for the slider. (default: TRUE).}

\item{slider_currentvalue_visible}{boolean indicating if the currently selected value should be displayed above the slider. (default: TRUE).}

\item{slider_tick_visible}{boolean indicating if the tickvalues should be displayed below the slider. (default: TRUE).}

\item{hover_hide}{boolean indicating if the hover label should be hidden or not; (default: FALSE).}

\item{color_palette}{a color palette vector.}

\item{categorical_color_range}{if the resulting heatmap holds categorical field values or continuous values that belong to a category; (default: FALSE).}

\item{category_items}{distinct/unique items of ordered category items}

\item{legend_items}{distinct/unique items of ordered legend items}
}
\value{
plot_ly object
}
\description{
Function to produce catmaply traces.
}
\keyword{internal}
