% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitCauchy.R
\name{profile.cauphyfit}
\alias{profile.cauphyfit}
\title{Method for Profiling \code{cauphyfit} Objects}
\usage{
\method{profile}{cauphyfit}(fitted, which = 1:npar, level = 0.8, npoints = 100, ...)
}
\arguments{
\item{fitted}{the \code{cauphyfit} fitted model object.}

\item{which}{the original model parameters which should be profiled. This can be a numeric or character vector. By default, all parameters are profiled.}

\item{level}{highest confidence level for parameters intervals, computed using the approximated Hessian (see \code{\link{compute_vcov}}).}

\item{npoints}{number of points to profile the likelihood for each parameter.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
An object of class \code{profile.cauphyfit}, 
which is a list with an element for each parameter being profiled.
The elements are data-frames with two variables:
\describe{
\item{\code{par.vals}:}{ a matrix of parameter values for each fitted model.}
\item{\code{profLogLik}:}{ the profile log likelihood.}
}
}
\description{
Investigates the profile log-likelihood function for a fitted model of class \code{cauphyfit}.
}
\details{
This function computes a confidence interval for the parameters using \code{\link{confint.cauphyfit}},
and then computes the likelihood function on a grid with \code{npoints} values
evenly spaced between the bounds of the interval, for each parameter one by one,
all other parameters being fixed.
}
\examples{
phy <- ape::rphylo(5, 0.1, 0)
dat <- rTraitCauchy(n = 1, phy = phy, model = "cauchy", parameters = list(root.value = 0, disp = 1))
fit <- fitCauchy(phy, dat, model = "cauchy", method = "reml")
pr <- profile(fit)
plot(pr)

}
\seealso{
\code{\link{fitCauchy}}, \code{\link{plot.profile.cauphyfit}}, \code{\link{profile}}.
}
