% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{Mroz}
\alias{Mroz}
\title{U.S. Women's Labor-Force Participation}
\format{
A data frame with 753 rows and 8 variables
\describe{
  \item{lfp}{Labor-force participation}
  \item{k5}{Number of children 5 years old or younger}
  \item{k618}{Number of children 6 to 17 years old}
  \item{age}{Age in years}
  \item{wc}{Wife attended college}
  \item{hc}{Husband attended college}
  \item{lwg}{Log expected wage rate. For women in the labor force, the actual wage rate; for women not in the labor force, an imputed value based on the regression of lwg on the other variables.}
  \item{inc}{Family income exclusive of wife's income}
}
}
\source{
Mroz, T. A. (1987) The sensitivity of an empirical model of married women's hours of work to economic and statistical assumptions. *Econometrica* 55, 765–799.

John Fox, Sanford Weisberg and Brad Price (2020). carData: Companion to Applied Regression Data Sets. R package version 3.0-4. \url{https://CRAN.R-project.org/package=carData}
}
\usage{
Mroz
}
\description{
The \code{Mroz} data frame has 753 rows and 8 columns. The observations, from the Panel Study of Income Dynamics (PSID), are married women.
}
\details{
This data set is a lightly edited version of the one found in the \emph{carData} package in R. It is used in the Describing Relationships chapter of \emph{The Effect}.
}
\references{
Fox, J. (2016) *Applied Regression Analysis and Generalized Linear Models,* Third Edition. Sage.

Fox, J. (2000) *Multiple and Generalized Nonparametric Regression.* Sage.

Fox, J. and Weisberg, S. (2019) *An R Companion to Applied Regression.* Third Edition, Sage.

Long. J. S. (1997) *Regression Models for Categorical and Limited Dependent Variables.* Sage.

Huntington-Klein. 2021. The Effect: An Introduction to Research Design and Causality. \url{https://theeffectbook.net}.
}
\keyword{datasets}
