% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/overlap_fun.R
\name{overlap_fun}
\alias{overlap_fun}
\title{This function creates an overlapping dataset}
\usage{
overlap_fun(Y,
                      treat,
                      treat_formula,
                      data_set,
                      n_class,
                      treat_mod,
                      link_function,
                      ...)
}
\arguments{
\item{Y}{is the the name of the outcome variable contained in \code{data}.}

\item{treat}{is the name of the treatment variable contained in
\code{data}.}

\item{treat_formula}{an object of class "formula" (or one that can be
coerced to that class) that regresses \code{treat} on a linear combination
of \code{X}: a symbolic description of the model to be fitted.}

\item{data_set}{is a dataframe containing \code{Y}, \code{treat}, and
\code{X}.}

\item{n_class}{is the number of classes to split \code{gps} into.}

\item{treat_mod}{a description of the error distribution to be used in the
model for treatment. Options include: \code{"Normal"} for normal model,
\code{"LogNormal"} for lognormal model, \code{"Poisson"} for Poisson model,
\code{"NegBinom"} for negative binomial model, \code{"Gamma"} for gamma
model.}

\item{link_function}{is either "log", "inverse", or "identity" for the
"Gamma" \code{treat_mod}.}

\item{...}{additional arguments to be passed to the treatment regression function}
}
\value{
\code{overlap_fun} returns a list containing the following
elements: \item{overlap_dataset}{dataframe containing overlapping data.}
\item{median_vec}{a vector containing median values.}
\item{overlap_treat_result}{the resulting treatment fit.}
}
\description{
This function ensures that the units overlap according to the estimated gps
values. The overlapping dataset depends on the number of classes
\code{n_class} to subclassify on.
}
\examples{
## Example from Schafer (2015).

example_data <- sim_data

overlap_list <- overlap_fun(Y = Y,
                  treat = T,
                  treat_formula = T ~ B.1 + B.2 + B.3 + B.4 + B.5 + B.6 + B.7 + B.8,
                  data_set = example_data,
                  n_class = 3,
                  treat_mod = "Normal")

overlapped_data <- overlap_list$overlap_dataset
summary(overlapped_data)

rm(example_data, overlap_list, overlapped_data)
}
\references{
Schafer, J.L., Galagate, D.L. (2015).  Causal inference with a
continuous treatment and outcome: alternative estimators for parametric
dose-response models. \emph{Manuscript in preparation}.

Bia, Michela, et al.
"A Stata package for the application of semiparametric estimators of dose response functions."
 \emph{Stata Journal} \bold{14.3} (2014): 580-604.
}
\seealso{
\code{\link{iptw_est}}, \code{\link{ismw_est}},
 \code{\link{reg_est}}, \code{\link{aipwee_est}}, \code{\link{wtrg_est}},
   etc. for other estimates.

\code{\link{t_mod}}, \code{\link{overlap_fun}} to prepare the \code{data}
for use in the different estimates.
}

