% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/by_genes_or_panel.R
\name{get_alias}
\alias{get_alias}
\title{Get Gene Name Alias for a Given Hugo Symbol}
\usage{
get_alias(hugo_symbol = NULL, base_url = NULL)
}
\arguments{
\item{hugo_symbol}{a hugo symbol for which to return aliases}

\item{base_url}{The database URL to query}
}
\value{
A character string with all aliases
}
\description{
This function grabs known gene aliases for a given Hugo Symbol.
You may notice that genes -alias pairs are not always consistent. For example
get_alias("KMT2D") will return "MLL2" but get_alias("MLL2") will not return "KMT2D"
This function relies on the existing cBioPortal API which controls this database
of aliases. Therefore, this is a convenience function but
you may want to consider a more carefully curated alias list like \code{cbioportalR::impact_gene_info}
}
\examples{
\dontshow{if (!httr::http_error("www.cbioportal.org/api")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

get_alias(hugo_symbol = "FGFR3", base_url = 'www.cbioportal.org/api')
get_alias(hugo_symbol = c("FGFR3", "TP53"), base_url = 'www.cbioportal.org/api')
\dontshow{\}) # examplesIf}
}
