% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ccRemover.R
\name{bootstrap_diff}
\alias{bootstrap_diff}
\title{Calculates the difference in the loading score for cell-cycle and control
genes}
\usage{
bootstrap_diff(xy, xn, nboot = 200, bar = TRUE)
}
\arguments{
\item{xy}{The data for the genes which are annotated to the cell-cycle, i.e.
those genes for which "if_cc" is \code{TRUE}.}

\item{xn}{The data for the genes which are not annotated to the cell-cycle,
control genes, genes for which "if_cc" is \code{FALSE}}

\item{nboot}{The number of bootstrap repititions to be carried out on each
iteration to determine the significance of each component.}

\item{bar}{Whether to display a progress bar or not. The progress bar will
not work in R-markdown enviornments so this option may be turned off. The
default value is \code{TRUE}.}
}
\value{
A data frame containing the loadings for each component on the
cell-cycle and control genes as well as the difference between the loadings
and the bootstrapped statistic for each loading.
}
\description{
This function is only used internally inside ccRemover. The function
calcualtes the average load difference on the cell-cycle and control genes.
Bootstrap resampling is then used to provide a score for each component.
Please see the original manuscript for the mathematical details.
}
