% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lme_model.R
\name{lme_model}
\alias{lme_model}
\title{Fits a Linear Mixed Effects Model}
\usage{
lme_model(
  dataset,
  ry,
  rind,
  rtime = NULL,
  rmet = NULL,
  vecD = NULL,
  covar = NULL,
  rho = 0,
  int = FALSE,
  cl = 0.95,
  control.lme = list(),
  apVar = TRUE,
  ...
)
}
\arguments{
\item{dataset}{an object of class \code{data.frame}.}

\item{ry}{Character string. Name of the outcome in the data set.}

\item{rind}{Character string. Name of the subject variable in the data set.}

\item{rtime}{Character string. Name of the time variable in the data set.}

\item{rmet}{Character string. Name of the method variable in the data set.}

\item{vecD}{Vector of weights. The length of the vector must be the same as the number of repeated measures.}

\item{covar}{Character vector. Name of covariates to include in the linear mixed model as fixed effects.}

\item{rho}{Within subject correlation structure. A value of 0 (default option) stands for compound symmetry and 1 is used for autoregressive of order 1 structure.}

\item{int}{Boolean indicating if the subject-method interaction has to be included in the model.}

\item{cl}{Confidence level.}

\item{control.lme}{A list of control values for the estimation algorithm used in \code{lme} function. For further details see \code{lme} help.}

\item{apVar}{Logical. Should the asymptotic variance-covariance matrix of the variance components be estimated in the linear mixed model? (Defaults to TRUE).}

\item{...}{To pass further arguments.}
}
\value{
an object of class \code{lme}.
}
\description{
Fits a Linear Mixed Effects Model
}
\examples{
# Reliability ICC
set.seed(2024)
df <- ccc_sim_data(b = NULL, g = NULL, mu = -0.25, sa = 1.5, se = 1)
mod1 <- lme_model(df,"y","id")
mod1

#Non-longitudinal Methods comparison data
set.seed(2024)
df2 <- ccc_sim_data(n=50,b = c(0,1), mu = -0.25, sa = 1.5, se = 1, nrep=2)
mod2 <- lme_model(df2,"y","id",rmet="met")
mod2

# Longitudinal Methods comparison data
set.seed(2024)
df3 <- ccc_sim_data(n=50, b = c(0,1), g=c(0,0.25,0.5), mu = -0.25, sa = 1.5, 
                    sab=0.25,sag=0.5,bg=c(0,0.5,0.75,0,1,1),se = 1, nrep=2)

mod3 <- lme_model(df3,"y","id","times","met",control.lme=nlme::lmeControl(opt = 'optim'))
mod3

}
