% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs-batch.R
\name{get_chem_info_batch}
\alias{get_chem_info_batch}
\title{Retrieve chemical information in batch search}
\usage{
get_chem_info_batch(
  DTXSID = NULL,
  type = "",
  API_key = NULL,
  rate_limit = 0L,
  Server = chemical_api_server,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{A vector of chemical identifier DTXSIDs}

\item{type}{A vector of type used in get_chem_info(). This specifies whether
to only grab predicted or experimental results. If not specified, it will
grab all details. The allowable input values are "", predicted", or
"experimental".}

\item{API_key}{The user-specific API key.}

\item{rate_limit}{Number of seconds to wait between each request}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A data.table containing chemical information for the chemicals with
DTXSID matching the input parameter.
}
\description{
Retrieve chemical information in batch search
}
\examples{
\dontshow{if (has_ccte_key() & is.na(ccte_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Pull chemical info for multiple chemicals
chem_info <- get_chem_info_batch(DTXSID = c('DTXSID7020182',
                                            'DTXSID2021315'))
\dontshow{\}) # examplesIf}
}
