% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs.R
\name{get_msready_by_dtxcid}
\alias{get_msready_by_dtxcid}
\title{Get msready by DTXCID}
\usage{
get_msready_by_dtxcid(
  DTXCID = NULL,
  API_key = NULL,
  Server = chemical_api_server,
  verbose = FALSE
)
}
\arguments{
\item{DTXCID}{The chemical identifier DTXCID}

\item{API_key}{The user-specific API key}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A character list of DTXSIDs with DTXCIDs matching the
search criteria
}
\description{
Get msready by DTXCID
}
\examples{
\dontshow{if (has_ccte_key() & is.na(ccte_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Pull chemicals with matching DTXCID
dtxcid_msready <- get_msready_by_dtxcid(DTXSID = 'DTXCID30182')
\dontshow{\}) # examplesIf}
}
