% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs.R
\name{get_msready_by_formula}
\alias{get_msready_by_formula}
\title{Get msready by formula}
\usage{
get_msready_by_formula(
  formula = NULL,
  API_key = NULL,
  Server = chemical_api_server,
  verbose = FALSE
)
}
\arguments{
\item{formula}{A string denoting the input chemical formula}

\item{API_key}{The user-specific API key}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A character list of DTXSIDs with chemical formulas matching the
search criteria
}
\description{
Get msready by formula
}
\examples{
\dontshow{if (has_ccte_key() & is.na(ccte_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Pull chemicals that match input formula
mass_formula <- get_msready_by_formula(formula = 'C16H24N2O5S')
\dontshow{\}) # examplesIf}
}
