% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CDF.R
\name{CDF}
\alias{CDF}
\title{Old version of CDF function}
\usage{
CDF(Y, X, Z = NULL, method = "linear regression", fast = TRUE)
}
\arguments{
\item{Y}{a numeric vector of size \code{n} containing the
preprocessed expressions from \code{n} samples (or cells).}

\item{X}{a data frame containing numeric or factor vector(s) of size \code{n}
containing the variable(s) to be tested (the condition(s) to be tested).}

\item{Z}{a data frame containing numeric or factor vector(s) of size \code{n}
containing the covariate(s).}

\item{method}{a character string indicating which method to use to
compute the CCDF, either \code{'linear regression'}, \code{'logistic regression'}
and  \code{'permutations'} or \code{'RF'} for Random Forests.
Default is \code{'linear regression'} since it is the method used in the test.}

\item{fast}{a logical flag indicating whether the fast implementation of
logistic regression should be used. Only if \code{'dist_permutations'} is specified.
Default is \code{TRUE}.}
}
\value{
A list with the following elements:\itemize{
  \item \code{cdf}: a vector of the cumulative distribution function of a given gene.
  \item \code{ccdf}: a vector of the conditional cumulative distribution function of a given gene, computed
  given \code{X}. Only if \code{Z} is \code{NULL}.
  \item \code{ccdf_nox}: a vector of the conditional cumulative distribution function of a given gene, computed
  given \code{Z} only (i.e. \code{X} is ignored.). Only if \code{Z} is not \code{NULL}.
  \item \code{ccdf_x}: a vector of the conditional cumulative distribution function of a given gene, computed
  given \code{X} and \code{Z}. Only if \code{Z} is not \code{NULL}.
  \item \code{y_sort}: a vector of the sorted expression points at which the CDF and the CCDFs are calculated.
  \item \code{x_sort}: a vector of the variables associated with \code{y_sort}.
  \item \code{z_sort}: a vector of the covariates associated with \code{y_sort}. Only if \code{Z} is not \code{NULL}.
}
}
\description{
Old version of CDF function
}
\examples{

X <- as.factor(rbinom(n=100, size = 1, prob = 0.5))
Y <- ((X==1)*rnorm(n = 50,0,1)) + ((X==0)*rnorm(n = 50,0.5,1))
res <- CDF(Y,X,method="linear regression")

}
\keyword{internal}
