% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoking.R
\name{pack_years_fun}
\alias{pack_years_fun}
\title{Smoking pack-years}
\usage{
pack_years_fun(
  SMKDSTY,
  DHHGAGE_cont,
  time_quit_smoking,
  SMKG203_cont,
  SMKG207_cont,
  SMK_204,
  SMK_05B,
  SMK_208,
  SMK_05C,
  SMKG01C_cont,
  SMK_01A
)
}
\arguments{
\item{SMKDSTY}{derived variable that classifies an individual's smoking
status.}

\item{DHHGAGE_cont}{continuous age variable.}

\item{time_quit_smoking}{derived variable that calculates the approximate
time a former smoker has quit smoking. 
See \code{\link{time_quit_smoking_fun}} for documentation on how variable
was derived}

\item{SMKG203_cont}{age started smoking daily. Variable asked to daily
smokers.}

\item{SMKG207_cont}{age started smoking daily. Variable asked to former
daily smokers.}

\item{SMK_204}{number of cigarettes smoked per day. Variable asked to
daily smokers.}

\item{SMK_05B}{number of cigarettes smoked per day. Variable asked to
occasional smokers}

\item{SMK_208}{number of cigarettes smoked per day. Variable asked to former
daily smokers}

\item{SMK_05C}{number of days smoked at least one cigarette}

\item{SMKG01C_cont}{age smoked first cigarette}

\item{SMK_01A}{smoked 100 cigarettes in lifetime (y/n)}
}
\value{
value for smoking pack-years in the Pack_years_der variable
}
\description{
This function creates a derived variable (pack_years_der) that
 measures an individual's smoking pack-years based on various CCHS smoking
 variables. This is a popular variable used by researchers to quantify
 lifetime exposure to cigarette use.
}
\details{
pack-years is calculated by multiplying the number of cigarette
 packs per day (20 cigarettes per pack) by the number of years. Example 1:
 a respondent who is a current smoker who smokes 1 package of cigarettes for
 the last 10 years has smoked 10 pack-years. Pack-years is also calculated
 for former smokers. Example 2: a respondent who started smoking at age
 20 years and smoked half a pack of cigarettes until age 40 years smoked for
 10 pack-years.
}
\examples{
# Using pack_years_fun() to create pack-years values across CCHS cycles
# pack_years_fun() is specified in variable_details.csv along with the CCHS
# variables and cycles included.

# To transform pack_years_der across cycles, use rec_with_table() for each
# CCHS cycle and specify pack_years_der, along with each smoking variable.
# Since time_quit_smoking_der is also a derived 
# variable, you will have to specify the variables that are derived from it.
# Then by using merge_rec_data(), you can combine pack_years_der across
# cycles

library(cchsflow)

pack_years2009_2010 <- rec_with_table(
  cchs2009_2010_p, c(
    "SMKDSTY", "DHHGAGE_cont", "SMK_09A_B", "SMKG09C", "time_quit_smoking",
    "SMKG203_cont", "SMKG207_cont", "SMK_204", "SMK_05B", "SMK_208",
    "SMK_05C", "SMK_01A", "SMKG01C_cont", "pack_years_der"
  )
)

head(pack_years2009_2010)

pack_years2011_2012 <- rec_with_table(
  cchs2011_2012_p,c(
    "SMKDSTY", "DHHGAGE_cont", "SMK_09A_B", "SMKG09C", "time_quit_smoking",
    "SMKG203_cont", "SMKG207_cont", "SMK_204", "SMK_05B", "SMK_208",
    "SMK_05C", "SMK_01A", "SMKG01C_cont", "pack_years_der"
  )
)

tail(pack_years2011_2012)

combined_pack_years <- suppressWarnings(merge_rec_data(pack_years2009_2010,
 pack_years2011_2012))

head(combined_pack_years)
tail(combined_pack_years)
}
