% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randConsensusMatrix.R
\name{randConsensusMatrix}
\alias{randConsensusMatrix}
\title{Calculate consensus weight matrix based on the permuted input label matrix. Internal function used by \code{callNCW}}
\usage{
randConsensusMatrix(
  l.seed,
  l.label = label,
  l.ns = ns,
  l.nc = nc,
  l.nv = nv,
  l.index = index,
  l.pair.ind = pair.ind,
  l.ppath = ppath,
  l.plot = plot
)
}
\arguments{
\item{l.seed}{A numerical value to set the random seed for reproducible results, 1000 random label matrix will be generated based on this seed number.}

\item{l.label}{A matrix or data frame of input labels, columns=different clustering results and rows are samples.}

\item{l.ns}{A integer value of number of samples, =\code{nrow(l.label)}}

\item{l.nc}{A integer value of number of samples, =\code{ncol(l.label)}}

\item{l.nv}{A integer vector of the number of non missing values for each column in \code{l.label}}

\item{l.index}{A list of index with length of \code{l.nc} of non missing values for each column in \code{l.label}}

\item{l.pair.ind}{A n-by-2 index matrix of array indices of upper triangular of \code{l.label} with non missing values}

\item{l.ppath}{A character value for output directory.}

\item{l.plot}{character value. NULL(default) - print to screen, 'pdf', 'png', 'pngBMP' for bitmap png, helpful for large datasets, or 'pdf'.}
}
\value{
A character of finished seed.

Write a binary file of 1000 random consensus weight matrix(as a vector n-by-1, n= nrow(\code{l.pair.ind})) with the seed \code{l.seed}, output file name: paste0("s",\code{l.seed},"rcw").
}
\description{
Calculate consensus weight matrix based on the permuted input label matrix. Internal function used by \code{callNCW}
}
