% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RowsColumns.R
\name{checkColsFormUniqueKeys}
\alias{checkColsFormUniqueKeys}
\title{Check that a set of columns form unique keys}
\usage{
checkColsFormUniqueKeys(data, keyColNames, allowNAKeys = FALSE)
}
\arguments{
\item{data}{data.frame to work with.}

\item{keyColNames}{character array of column names to check.}

\item{allowNAKeys}{logical if FALSE throw if there are NAs in the key columns.}
}
\value{
logical TRUE if the rows of data are unique addressable by the columns named in keyColNames.
}
\description{
Check that a set of columns form unique keys
}
\examples{

d <- data.frame(key= c('a','a', 'b'))
checkColsFormUniqueKeys(d, 'key')

}
