% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RowsColsQ.R
\name{build_pivot_control_q}
\alias{build_pivot_control_q}
\title{Build a blocks_to_rowrecs_q() control table that specifies a pivot (query based, takes name of table).}
\usage{
build_pivot_control_q(
  tableName,
  columnToTakeKeysFrom,
  columnToTakeValuesFrom,
  my_db,
  ...,
  prefix = columnToTakeKeysFrom,
  sep = NULL,
  qualifiers = NULL
)
}
\arguments{
\item{tableName}{Name of table to scan for new column names.}

\item{columnToTakeKeysFrom}{character name of column build new column names from.}

\item{columnToTakeValuesFrom}{character name of column to get values from.}

\item{my_db}{db handle}

\item{...}{not used, force later args to be by name}

\item{prefix}{column name prefix (only used when sep is not NULL)}

\item{sep}{separator to build complex column names.}

\item{qualifiers}{optional named ordered vector of strings carrying additional db hierarchy terms, such as schema.}
}
\value{
control table
}
\description{
Some discussion and examples can be found here: \url{https://winvector.github.io/FluidData/FluidData.html}.
}
\examples{

if (requireNamespace("DBI", quietly = TRUE) &&
  requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  d <- data.frame(measType = c("wt", "ht"),
                  measValue = c(150, 6),
                  stringsAsFactors = FALSE)
  rquery::rq_copy_to(my_db,
                    'd',
                    d,
                    overwrite = TRUE,
                    temporary = TRUE)
  build_pivot_control_q('d', 'measType', 'measValue',
                        my_db = my_db,
                        sep = '_') \%.>\%
     print(.)
  DBI::dbDisconnect(my_db)
}

}
\seealso{
\code{\link{blocks_to_rowrecs_q}}, \code{\link{build_pivot_control}}
}
\keyword{internal}
