% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opspec.R
\name{layout_specification}
\alias{layout_specification}
\title{Create a record to record spec.}
\usage{
layout_specification(
  incoming_shape,
  outgoing_shape,
  ...,
  recordKeys = character(0),
  incoming_controlTableKeys = colnames(incoming_shape)[[1]],
  outgoing_controlTableKeys = colnames(outgoing_shape)[[1]],
  checkNames = TRUE,
  checkKeys = TRUE,
  strict = FALSE,
  allow_rqdatatable_in = FALSE,
  allow_rqdatatable_out = TRUE
)
}
\arguments{
\item{incoming_shape}{data.frame, definition of incoming record shape.}

\item{outgoing_shape}{data.frame, defintion of outgoing record shape.}

\item{...}{not used, force later arguments to bind by name.}

\item{recordKeys}{vector of columns identifying records.}

\item{incoming_controlTableKeys}{character, which column names of the incoming control table are considered to be keys.}

\item{outgoing_controlTableKeys}{character, which column names of the outgoing control table are considered to be keys.}

\item{checkNames}{passed to rowrecs_to_blocks.}

\item{checkKeys}{passed to rowrecs_to_blocks.}

\item{strict}{passed to rowrecs_to_blocks.}

\item{allow_rqdatatable_in}{logical, if TRUE allow rqdatatable shortcutting on simple conversions.}

\item{allow_rqdatatable_out}{logical, if TRUE allow rqdatatable shortcutting on simple conversions.}
}
\value{
a record specification object
}
\description{
Create a general record to record transform specification.
}
\examples{


incoming_shape <- qchar_frame(
  "row",  "col1", "col2", "col3" |
  "row1",   v11,     v12,  v13   |
  "row2",   v21,     v22,  v23   |
  "row3",   v31,     v32,  v33   )


outgoing_shape <- qchar_frame(
  "column", "row1", "row2", "row3" |
  "col1",      v11,  v21  ,  v31   |
  "col2",      v12,  v22  ,  v32   |
  "col3",      v13,  v23  ,  v33   )

data <- build_frame(
  'record_id', 'row',  'col1', 'col2', 'col3'  |
  1,           'row1',  1,      2,      3      |
  1,           'row2',  4,      5,      6      |
  1,           'row3',  7,      8,      9      |
  2,           'row1',  11,     12,     13     |
  2,           'row2',  14,     15,     16     |
  2,           'row3',  17,     18,     19     )

print(data)

layout <- layout_specification(
  incoming_shape = incoming_shape,
  outgoing_shape = outgoing_shape,
  recordKeys = 'record_id')

print(layout)

data \%.>\% layout

data \%.>\% layout \%.>\% .(t(layout))

}
