% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qrMethod.R
\name{summary.cdfqr}
\alias{summary.cdfqr}
\alias{print.cdfqr}
\alias{coef.cdfqr}
\alias{vcov.cdfqr}
\alias{update.cdfqr}
\alias{confint.cdfqr}
\alias{formula.cdfqr}
\alias{nobs.cdfqr}
\alias{deviance.cdfqr}
\alias{logLik.cdfqrH}
\alias{confint.cdfqrH}
\alias{confint.cdfqrFT}
\title{S3 Methods for getting output from fitted cdfqr Objects.}
\usage{
\method{summary}{cdfqr}(object, ...)

\method{print}{cdfqr}(x, digits = max(3, getOption("digits") - 3), ...)

\method{coef}{cdfqr}(object, type = "full", ...)

\method{vcov}{cdfqr}(object, type = "full", ...)

\method{update}{cdfqr}(object, formula., zero.fo., one.fo., mu.fo., ..., evaluate = TRUE)

\method{confint}{cdfqr}(object, parm, level = 0.95, submodel = "full", ...)

\method{formula}{cdfqr}(x, ...)

\method{nobs}{cdfqr}(object, ...)

\method{deviance}{cdfqr}(object, ...)

\method{logLik}{cdfqrH}(object, ...)

\method{confint}{cdfqrH}(
  object,
  parm,
  level = 0.95,
  type = c("full", "mean", "sigma", "zero", "one"),
  ...
)

\method{confint}{cdfqrFT}(object, parm, level = 0.95, submodel = "full", ...)
}
\arguments{
\item{...}{Pass onto other functions or currently ignored}

\item{x, object}{The fitted cdfqr model.}

\item{digits}{Number of digits to be retained in printed output.}

\item{type, submodel}{The parts of coefficients or variance-covariance matrix to be extracted.Can be "full", "mean",or "sigma".}

\item{formula.}{Changes to the formula. See \code{\link[Formula]{update.Formula}} for details.}

\item{zero.fo., one.fo., mu.fo., }{Changes to the formulas for zero/one component for hurdle models, and for location submodel for finite-tailed models.}

\item{evaluate}{If true evaluate the new updated model else return the call for the new model.}

\item{parm}{a specification of which parameters are to be given confidence intervals, either a vector of numbers or a vector of names. If missing, all parameters are considered.}

\item{level}{the confidence level required.}
}
\description{
Give the S3 Methods for CDF-Quantile Distribution Models
}
\examples{
data(cdfqrExampleData)
fit <- cdfquantreg(crc99 ~ vert | confl, 't2','t2', data = JurorData)

summary(fit)
print(fit)
logLik(fit)
coef(fit)
deviance(fit)
vcov(fit)
confint(fit)

#Update the model
fit2 <- update(fit, crc99 ~ vert*confl | confl)
summary(fit2)
}
