% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/what_if.R
\name{ceteris_paribus}
\alias{ceteris_paribus}
\title{Ceteris Paribus Plot}
\usage{
ceteris_paribus(explainer, observation, grid_points = 101,
  selected_variables = NULL)
}
\arguments{
\item{explainer}{a model to be explained, preprocessed by the 'DALEX::explain' function}

\item{observation}{a new observarvation for which predictions need to be explained}

\item{grid_points}{number of points used for response path}

\item{selected_variables}{if specified, then only these variables will be explained}
}
\value{
An object of the class 'ceteris_paribus_explainer'.
It's a data frame with calculated average responses.
}
\description{
Ceteris Paribus Plot
}
\examples{
library("DALEX")
library("randomForest")
set.seed(59)

apartments_rf_model <- randomForest(m2.price ~ construction.year + surface + floor +
      no.rooms + district, data = apartments)

explainer_rf <- explain(apartments_rf_model,
      data = apartmentsTest[,2:6], y = apartmentsTest$m2.price)

new_apartment <- apartmentsTest[1, ]
new_apartment

wi_rf <- ceteris_paribus(explainer_rf, observation = new_apartment)
wi_rf
wi_rf <- ceteris_paribus(explainer_rf, observation = new_apartment,
         selected_variables = c("surface", "floor", "no.rooms"))
wi_rf
}
