% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_metrics.R
\name{cfbd_metrics_ppa_players_games}
\alias{cfbd_metrics_ppa_players_games}
\title{\strong{Get player game averages for predicted points added (PPA)}}
\usage{
cfbd_metrics_ppa_players_games(
  year = NULL,
  week = NULL,
  team = NULL,
  position = NULL,
  athlete_id = NULL,
  threshold = NULL,
  excl_garbage_time = FALSE
)
}
\arguments{
\item{year}{(\emph{Integer} required): Year, 4 digit format (\emph{YYYY})}

\item{week}{(\emph{Integer} optional): Week - values range from 1-15, 1-14 for seasons pre-playoff, i.e. 2013 or earlier}

\item{team}{(\emph{String} optional): D-I Team. Required if year not provided.}

\item{position}{(\emph{string} optional): Position abbreviation of the player you are searching for.\cr
Position Group  - options include:\cr
\itemize{
\item Offense: QB, RB, FB, TE,  OL, G, OT, C, WR\cr
\item Defense: DB, CB, S, LB,  DE, DT, NT, DL\cr
\item Special Teams: K, P, LS, PK\cr
}}

\item{athlete_id}{(\emph{Integer} optional): Athlete ID filter for querying a single athlete\cr
Can be found using the \code{\link[=cfbd_player_info]{cfbd_player_info()}} function.}

\item{threshold}{(\emph{Integer} optional): Minimum threshold of plays.}

\item{excl_garbage_time}{(\emph{Logical} default FALSE): Select whether to exclude Garbage Time (TRUE or FALSE)}
}
\value{
\code{\link[=cfbd_metrics_ppa_players_games]{cfbd_metrics_ppa_players_games()}} - A data frame with 9 variables:
\describe{
\item{\code{season}: integer.}{Season of the game.}
\item{\code{week}: integer.}{Game week of the season.}
\item{\code{name}: character.}{Athlete name.}
\item{\code{position}: character.}{Athlete position.}
\item{\code{team}: character.}{Team name.}
\item{\code{opponent}: character.}{Team Opponent name.}
\item{\code{avg_PPA_all}: double.}{Average overall predicted points added (PPA).}
\item{\code{avg_PPA_pass}: double.}{Average passing predicted points added (PPA).}
\item{\code{avg_PPA_rush}: double.}{Average rushing predicted points added (PPA).}
}
}
\description{
\strong{Get player game averages for predicted points added (PPA)}
}
\examples{
\donttest{
cfbd_metrics_ppa_players_games(year = 2019, week = 3, team = "TCU")
}

}
\keyword{Players}
\keyword{Points}
\keyword{Predicted}
