% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateData.R
\name{generate_Markov}
\alias{generate_Markov}
\title{Generate Markov Trajectories}
\usage{
generate_Markov(
  n = 5,
  K = 2,
  P = (1 - diag(K))/(K - 1),
  lambda = rep(1, K),
  pi0 = c(1, rep(0, K - 1)),
  Tmax = 1,
  labels = NULL
)
}
\arguments{
\item{n}{number of trajectories to generate}

\item{K}{number of states}

\item{P}{matrix containing the transition probabilities from one state to another. Each row contains positive reals summing to 1.}

\item{lambda}{time spent in each state}

\item{pi0}{initial distribution of states}

\item{Tmax}{maximal duration of trajectories}

\item{labels}{state names. If \code{NULL}, integers are used}
}
\value{
a data.frame with 3 columns: \code{id}, id of the trajectory, \code{time}, time at which a change occurs and \code{state}, new state.
}
\description{
Simulate individuals from a Markov process defined by a transition matrix, time spent in each time and initial probabilities.
}
\details{
For one individual, assuming the current state is \eqn{s_j} at time \eqn{t_j}, the next state and time is simulated as follows:
\enumerate{
\item generate one sample, \eqn{d}, of an exponential law of parameter \code{lambda[s_j]}
\item define the next time values as: \eqn{t_{j+1} = t_j + d}
\item generate the new state \eqn{s_{j+1}} using a multinomial law with probabilities \code{Q[s_j,]}
}
}
\examples{
# Simulate the Jukes-Cantor model of nucleotide replacement
K <- 4
PJK <- matrix(1 / 3, nrow = K, ncol = K) - diag(rep(1 / 3, K))
lambda_PJK <- c(1, 1, 1, 1)
d_JK <- generate_Markov(
  n = 100, K = K, P = PJK, lambda = lambda_PJK, Tmax = 10,
  labels = c("A", "C", "G", "T")
)

head(d_JK)
}
\author{
Cristian Preda
}
