% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{flours}
\alias{flours}
\title{Flours dataset}
\format{
\code{flours} is a list of 3 elements:
\itemize{
  \item \code{data} A matrix of size 241*115 containing the resistance of dough (measured every 2s) during the kneading
process. One dough batch = 1 column
  \item \code{quality} Quality of cookies baked with the associated dough (1=Good, 2=Medium, 3=Bad)
  \item \code{time} time values
}
}
\usage{
data(flours)
}
\description{
Resistance of dough during the kneading process
}
\examples{
data(flours)

matplot(flours$time, flours$data, col = flours$quality, type = "l", lty = 1)

# convert to categorical data
flours_cfd <- convertToCfd(flours$data, breaks = c(-Inf, 150, 300, 450, 600, Inf),
                           times = flours$time)

plotData(flours_cfd, group = flours$quality)


# convert to categorical data after projecting in a basis of functions
basis <- create.bspline.basis(c(0, 480), nbasis = 10)
flours_fd <- Data2fd(flours$time, flours$data, basis)
plot(flours_fd)

flours_cfd2 <- convertToCfd(flours_fd, breaks = c(-Inf, 150, 300, 450, 600, Inf))

plotData(flours_cfd2, group = flours$quality)
}
\seealso{
Other datasets: 
\code{\link{biofam2}},
\code{\link{care}}
}
\concept{datasets}
\keyword{data}
