% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cff_parse_person.R
\name{cff_parse_person}
\alias{cff_parse_person}
\title{Parse a person to \code{cff}}
\usage{
cff_parse_person(person)
}
\arguments{
\item{person}{A \code{person} object or a character coercible to \code{person}. See
\code{\link[utils:person]{utils::person()}}.}
}
\value{
A \code{\link{cff}} object ready to be used on \code{\link[=cff_create]{cff_create()}}.
}
\description{
Parse a person or string to a valid format for a \code{CITATION.cff} file.
}
\details{
This is a helper function designed to help on adding or
replacing the auto-generated authors of the package. See \strong{Examples}.
}
\examples{
# Parse a person object

cff_parse_person(person(
  given = "First",
  family = "Author",
  role = c("aut", "cre"),
  email = "first.last@example.com",
  comment = c(
    ORCID = "0000-0001-8457-4658",
    affiliation = "An affiliation"
  )
))

# Parse a string

cff_parse_person("Julio Iglesias <fake@email.com>")

# Several persons
persons <- c(person("Clark", "Kent"), person("Lois", "Lane"))

cff_parse_person(persons)
}
\seealso{
\code{\link[=cff_create]{cff_create()}}, \code{vignette("cffr", "cffr")}, \code{\link[utils:person]{utils::person()}}

Other parsers: 
\code{\link{cff_parse_citation}()}
}
\concept{parsers}
