\name{umbrella}

\alias{umbrella}

\title{Specify an Umbrella-Ordering in a CGAM Formula}

\description{A symbolic routine to define that the response has an umbrella-ordering in a predictor in a formula argument to cgam.}

\usage{umbrella(x)}

\arguments{
  \item{x}{A numeric vector which has the same length as the response vector.}
}

\details{
  'umbrella' returns the vector "x" and imposes on it a shape attribute: "umbrella". According to the value of the vector itself and its shape attribute, the cone edges of the cone generated by the constraint matrix, which constrains that the response has an umbrella-ordering in "x"  will be made. The cone edges are a set of basis employed in the hinge algorithm. 

  Note that 'umbrella' does not make the corresponding cone edges itself. It sets things up to a sub-routine called umbrella.fun in cgam which will make the cone edges. An umbrella-ordering is a partial ordering: Suppose we have a \eqn{x_0} that is known to be a "mode" so that for \eqn{x, y >= x_0}, we have a binary relation between \eqn{x} and \eqn{y} if \eqn{x <= y} and for \eqn{x, y <= x_0} we have the same binary relation if \eqn{x <= y}, but if \eqn{x < x_0} and \eqn{y > x_0}, there is no such binary relation.  

  See references cited in this section for more details.
}

\value{
  The vector x with an umbrella-ordering tag.
}

\author{
  Mary C. Meyer and Xiyue Liao
}

\references{
  Meyer, M. C. (2013b) A simple new algorithm for quadratic programming with applications in statistics. \emph{Communications in Statistics \bold{42(5)}}, 1126--1139. 
}

\examples{
  # generate y
  set.seed(123)
  n <- 20
  x <- seq(-2, 2, length = n)
  y <- - x^2 + rnorm(n)

  # regress y on x under the umbrella-ordering restriction
  ans <- cgam(y ~ umbrella(x)) 

  # make a plot
  par(mar = c(4, 4, 1, 1))
  plot(y, cex = .7, ylab = "y")
  lines(ans$muhat, col = 2)
  legend("topleft", bty = "n", "umbrella-ordering fit", col = 2, lty = 1)
}

\seealso{
  \code{\link{tree}}
}

\keyword{shape routine}



















