% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgr_helper_mat_2.R
\name{cgr_helper_mat_2}
\alias{cgr_helper_mat_2}
\title{Continuous time Generalized Rapid response CUSUM (CGR-CUSUM) helper - matrix
formulation of the problem - version 2}
\usage{
cgr_helper_mat_2(data, ctimes, coxphmod, cbaseh, displaypb = FALSE)
}
\arguments{
\item{data}{\code{data.frame} containing the following named columns:
\itemize{
\item \code{entrytime} numeric - time of entry into study,
\item \code{otime} numeric - time from entry until event,
\item \code{censorid} integer - (optional) censoring indicator (0 = right censored, 1 = observed),
} and optionally additional covariates used for risk-adjustment.}

\item{ctimes}{(optional) vector of construction times at which the value of the chart should be
determined. When not specified, the chart is constructed at all failure times.}

\item{coxphmod}{(optional) a cox proportional hazards regression model as produced by
the function \code{\link[survival:coxph]{coxph()}}. Standard practice: \cr
\code{coxph(Surv(survtime, censorid) ~ covariates, data = data)}. \cr
Alternatively, a list with:
\itemize{
\item $formula (~ covariates)
\item $coefficients (named vector specifying risk adjustment coefficients
for covariates - names must be the same as in $formula and colnames of \code{data}).
}}

\item{cbaseh}{a function which returns the non risk-adjusted cumulative
baseline hazard \eqn{H_0(t)}{H_0(t)}. If \code{cbaseh} is missing but
\code{coxphmod} has been
specified as a survival object, this baseline hazard rate will be determined
using the provided \code{coxphmod}.}

\item{displaypb}{boolean Display a progress bar?}
}
\value{
A matrix with 4 named columns:
\itemize{
\item $time time at which the value of the CGR-CUSUM was determined
\item $value value at corresponding time of the CGR-CUSUM
\item $exp_theta_t value at corresponding time of the MLE \eqn{\hat{\theta}_t}{\theta_t}
\item $S_nu time from which individuals contribute to the chart \eqn{S_\nu}{S_\nu}
}
}
\description{
This function calculates the value of the CGR-CUSUM using a
matrix formulation of the problem - this can require a lot of available RAM.
}
\examples{
\dontrun{
require(survival)
tdat <- subset(surgerydat, Hosp_num == 1)
tdat$otime <- tdat$entrytime + tdat$survtime
tcbaseh <- function(t) chaz_exp(t, lambda = 0.01)
varsanalysis <- c("age", "sex", "BMI")
exprfit <- as.formula(paste("Surv(survtime, censorid) ~" ,paste(varsanalysis, collapse='+')))
tcoxmod <- coxph(exprfit, data= surgerydat)
#Alternatively, cbaseh can be left empty when specifying coxphmod through coxph()
cgr2 <- cgr_helper_mat_2(data = tdat, ctimes = unique(tdat$entrytime + tdat$survtime),
                         coxphmod = tcoxmod, cbaseh = tcbaseh, displaypb = TRUE)
}
}
\seealso{
\code{\link{cgrcusum}}
}
\author{
Daniel Gomon
}
