% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{logLik.chandwich}
\alias{logLik.chandwich}
\title{Extract log-likelihood for objects of class "chandwich"}
\usage{
\method{logLik}{chandwich}(object, ...)
}
\arguments{
\item{object}{an object of class "chandwich", a result of a call to
\code{\link{adjust_loglik}}.}

\item{...}{Additional optional arguments. At present no optional
arguments are used.}
}
\value{
An object of class \code{"logLik"}: a numeric scalar with
value equal to the maximised (independence) loglikelihood, that is,
the value of the independence loglikelihood at the MLE, and the
attribute \code{"df"}, which gives the number of free parameters estimated.
}
\description{
\code{logLik} method for class "chandwich".
}
\details{
The value of the maximised (independence) loglikelihood
is extracted from \code{attr(object, "max_loglik")}.  It is also equal
to \code{object(attr(object, "MLE"))}.
}
\seealso{
\code{\link{coef.chandwich}}: \code{coef} method for
  class "chandwich".

\code{\link{vcov.chandwich}}: \code{vcov} method for
  class "chandwich".

\code{\link{summary.chandwich}}: \code{summary} method for
  class "chandwich".

\code{\link{adjust_loglik}} to adjust a user-supplied
  loglikelihood.
}
