% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changer.R
\name{changer}
\alias{changer}
\title{Change Name of Existing R Package}
\usage{
changer(
  path,
  new_name,
  check_validity = TRUE,
  change_git = TRUE,
  run_roxygen = FALSE,
  remote_name = NULL,
  ask = TRUE
)
}
\arguments{
\item{path}{Path of the package.}

\item{new_name}{Desired name of the package.}

\item{check_validity}{Check first if the package name is valid and available by running the 
function \code{available} from the package \code{available} Default is TRUE. This will prompt a warning about
potentially offensive results from Urban Dictionary which is used to check the validity of the package name.}

\item{change_git}{If \code{TRUE} (default), changes the remote url of the remote. Note that
you still need to change the name of the GitHub repository manually as follows: 
Go to the URL of your Github package, click Settings, change the name under "Repository name", and click Rename.}

\item{run_roxygen}{Should the package documentation be updated via roxygen? If \code{TRUE}, removes all old \code{Rd} files 
in \code{man} directory.}

\item{remote_name}{Name of the remote. Defaults to \code{git2r::remotes(path)[1]}.}

\item{ask}{Ask confirmation before starting the rename process. Default is TRUE.}
}
\description{
Changing the name of an existing R package is annoying but common task 
especially in the early stages of package development. Function \code{changer} 
tries to automate this task. See README for more information.
}
\details{
Note that if the package is already published in CRAN, then the name change 
is more problematic (you need to ask CRAN for permission first).

If the package is also available in Github, then you need to do the following:

Go to the URL of your Github package, click Settings near the top-right, change the name under "Repository name", and finally click Rename.

Warnings: 

If the current name of your package is just some commonly used word (such as "package"), then you are in trouble, as 
find and replace will change all of those words to \code{new_name} as well. 

If you have a function with same name as your package, that will change as well.

It is strongly recommended to make backups before proceeding.

Inspired by Nick Tierney's blog post: https://www.njtierney.com/post/2017/10/27/change-pkg-name/
}
\examples{
content <- letters
package.skeleton("package.with.boring.name", path = tempdir())
readLines(file.path(tempdir(), "package.with.boring.name", "DESCRIPTION"))

changer(file.path(tempdir(), "package.with.boring.name"), 
  new_name = "superpack", check_validity = FALSE, ask = FALSE)
readLines(file.path(tempdir(), "superpack", "DESCRIPTION"))
unlink(file.path(tempdir(), "superpack"), recursive = TRUE)

}
