% Generated by roxygen2 (4.0.1): do not edit by hand
\name{checkFunction}
\alias{assertFunction}
\alias{checkFunction}
\alias{testFunction}
\title{Check if an argument is a function}
\usage{
checkFunction(x, args = NULL, ordered = FALSE)

assertFunction(x, args = NULL, ordered = FALSE, .var.name)

testFunction(x, args = NULL, ordered = FALSE)
}
\arguments{
\item{x}{[ANY]\cr
Object to check.}

\item{.var.name}{[character(1)]\cr
Name for \code{x}. Defaults to a heuristic to determine
the name using \code{\link[base]{deparse}} and \code{\link[base]{substitute}}.}

\item{args}{[\code{character}]\cr
Expected formal arguments. Checks that a function has no arguments if
set to \code{character(0)}.
Default is \code{NULL} (no check).}

\item{ordered}{[\code{logical(1)}]\cr
Flag whether the arguments provided in \code{args} must be the first
\code{length(args)} arguments of the function in the specified order.
Default is \code{FALSE}.}
}
\value{
Depending on the function prefix:
 If the check is successful, all functions return \code{TRUE}.
 If the check is not successful, \code{assertFunction} throws an error message,
 \code{testFunction} returns \code{FALSE} and \code{checkFunction} returns
 a string with the error message.
}
\description{
Check if an argument is a function
}
\examples{
testFunction(mean)
testFunction(mean, args = "x")
}
\seealso{
Other basetypes: \code{\link{assertArray}},
  \code{\link{checkArray}}, \code{\link{testArray}};
  \code{\link{assertAtomicVector}},
  \code{\link{checkAtomicVector}},
  \code{\link{testAtomicVector}};
  \code{\link{assertAtomic}}, \code{\link{checkAtomic}},
  \code{\link{testAtomic}}; \code{\link{assertCharacter}},
  \code{\link{checkCharacter}},
  \code{\link{testCharacter}}; \code{\link{assertComplex}},
  \code{\link{checkComplex}}, \code{\link{testComplex}};
  \code{\link{assertDataFrame}},
  \code{\link{checkDataFrame}},
  \code{\link{testDataFrame}};
  \code{\link{assertEnvironment}},
  \code{\link{checkEnvironment}},
  \code{\link{testEnvironment}};
  \code{\link{assertFactor}}, \code{\link{checkFactor}},
  \code{\link{testFactor}}; \code{\link{assertIntegerish}},
  \code{\link{checkIntegerish}},
  \code{\link{testIntegerish}};
  \code{\link{assertInteger}}, \code{\link{checkInteger}},
  \code{\link{testInteger}}; \code{\link{assertList}},
  \code{\link{checkList}}, \code{\link{testList}};
  \code{\link{assertLogical}}, \code{\link{checkLogical}},
  \code{\link{testLogical}}; \code{\link{assertMatrix}},
  \code{\link{checkMatrix}}, \code{\link{testMatrix}};
  \code{\link{assertNumeric}}, \code{\link{checkNumeric}},
  \code{\link{testNumeric}}; \code{\link{assertVector}},
  \code{\link{checkVector}}, \code{\link{testVector}}
}

