% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/checkDataFrame.r
\name{checkDataFrame}
\alias{assertDataFrame}
\alias{checkDataFrame}
\alias{testDataFrame}
\title{Check if an argument is a data frame}
\usage{
checkDataFrame(x, types = character(0L), any.missing = TRUE,
  min.rows = NULL, min.cols = NULL, nrows = NULL, ncols = NULL,
  row.names = NULL, col.names = NULL)

assertDataFrame(x, types = character(0L), any.missing = TRUE,
  min.rows = NULL, min.cols = NULL, nrows = NULL, ncols = NULL,
  row.names = NULL, col.names = NULL, .var.name)

testDataFrame(x, types = character(0L), any.missing = TRUE,
  min.rows = NULL, min.cols = NULL, nrows = NULL, ncols = NULL,
  row.names = NULL, col.names = NULL)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{types}{[\code{character}]\cr
Character vector of class names. Each list element must inherit
from at least one of the provided types.
The types \dQuote{logical}, \dQuote{integer}, \dQuote{integerish}, \dQuote{double},
\dQuote{numeric}, \dQuote{complex}, \dQuote{character}, \dQuote{factor}, \dQuote{atomic}, \dQuote{vector}
\dQuote{atomicvector}, \dQuote{array}, \dQuote{matrix}, \dQuote{list}, \dQuote{function},
\dQuote{environment} and \dQuote{null} are supported.
For other types \code{\link[base]{inherits}} is used as a fallback to check \code{x}'s inheritance.
Defaults to \code{character(0)} (no check).}

\item{any.missing}{[\code{logical(1)}]\cr
Are missing values allowed? Default is \code{TRUE}.}

\item{min.rows}{[\code{integer(1)}]\cr
Minimum number of rows.}

\item{min.cols}{[\code{integer(1)}]\cr
Minimum number of columns.}

\item{nrows}{[\code{integer(1)}]\cr
Exact number of rows.}

\item{ncols}{[\code{integer(1)}]\cr
Exact number of columns.}

\item{row.names}{[\code{character(1)}]\cr
Check for row names. Default is \dQuote{NULL} (no check).
See \code{\link{checkNamed}} for possible values.}

\item{col.names}{[\code{character(1)}]\cr
Check for column names. Default is \dQuote{NULL} (no check).
See \code{\link{checkNamed}} for possible values.}

\item{.var.name}{[character(1)]\cr
Name for \code{x}. Defaults to a heuristic to determine
the name using \code{\link[base]{deparse}} and \code{\link[base]{substitute}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, all functions return \code{TRUE}.
 If the check is not successful, \code{assertDataFrame} throws an error message,
 \code{testDataFrame} returns \code{FALSE} and \code{checkDataFrame} returns
 a string with the error message.
}
\description{
Check if an argument is a data frame
}
\examples{
testDataFrame(iris, "data.frame")
testDataFrame(iris, "data.frame", min.rows = 1, col.names = "named")
}
\seealso{
Other basetypes: \code{\link{assertArray}},
  \code{\link{checkArray}}, \code{\link{testArray}};
  \code{\link{assertAtomicVector}},
  \code{\link{checkAtomicVector}},
  \code{\link{testAtomicVector}};
  \code{\link{assertAtomic}}, \code{\link{checkAtomic}},
  \code{\link{testAtomic}}; \code{\link{assertCharacter}},
  \code{\link{checkCharacter}},
  \code{\link{testCharacter}}; \code{\link{assertComplex}},
  \code{\link{checkComplex}}, \code{\link{testComplex}};
  \code{\link{assertEnvironment}},
  \code{\link{checkEnvironment}},
  \code{\link{testEnvironment}};
  \code{\link{assertFactor}}, \code{\link{checkFactor}},
  \code{\link{testFactor}}; \code{\link{assertFunction}},
  \code{\link{checkFunction}}, \code{\link{testFunction}};
  \code{\link{assertIntegerish}},
  \code{\link{checkIntegerish}},
  \code{\link{testIntegerish}};
  \code{\link{assertInteger}}, \code{\link{checkInteger}},
  \code{\link{testInteger}}; \code{\link{assertList}},
  \code{\link{checkList}}, \code{\link{testList}};
  \code{\link{assertLogical}}, \code{\link{checkLogical}},
  \code{\link{testLogical}}; \code{\link{assertMatrix}},
  \code{\link{checkMatrix}}, \code{\link{testMatrix}};
  \code{\link{assertNumeric}}, \code{\link{checkNumeric}},
  \code{\link{testNumeric}}; \code{\link{assertVector}},
  \code{\link{checkVector}}, \code{\link{testVector}}
}

