% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkMatrix.r
\name{checkMatrix}
\alias{assertMatrix}
\alias{assert_matrix}
\alias{checkMatrix}
\alias{expect_matrix}
\alias{testMatrix}
\alias{test_matrix}
\title{Check if an argument is a matrix}
\usage{
checkMatrix(x, mode = NULL, any.missing = TRUE, all.missing = TRUE,
  min.rows = NULL, min.cols = NULL, nrows = NULL, ncols = NULL,
  row.names = NULL, col.names = NULL)

assertMatrix(x, mode = NULL, any.missing = TRUE, all.missing = TRUE,
  min.rows = NULL, min.cols = NULL, nrows = NULL, ncols = NULL,
  row.names = NULL, col.names = NULL, add = NULL, .var.name)

assert_matrix(x, mode = NULL, any.missing = TRUE, all.missing = TRUE,
  min.rows = NULL, min.cols = NULL, nrows = NULL, ncols = NULL,
  row.names = NULL, col.names = NULL, add = NULL, .var.name)

testMatrix(x, mode = NULL, any.missing = TRUE, all.missing = TRUE,
  min.rows = NULL, min.cols = NULL, nrows = NULL, ncols = NULL,
  row.names = NULL, col.names = NULL)

test_matrix(x, mode = NULL, any.missing = TRUE, all.missing = TRUE,
  min.rows = NULL, min.cols = NULL, nrows = NULL, ncols = NULL,
  row.names = NULL, col.names = NULL)

expect_matrix(x, mode = NULL, any.missing = TRUE, all.missing = TRUE,
  min.rows = NULL, min.cols = NULL, nrows = NULL, ncols = NULL,
  row.names = NULL, col.names = NULL, info = NULL, label = NULL)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{mode}{[\code{character(1)}]\cr
Storage mode of the array. Arrays can hold vectors, i.e. \dQuote{logical},
\dQuote{integer}, \dQuote{double}, \dQuote{numeric}, \dQuote{complex},
\dQuote{character} and \dQuote{list}. You can also specify \dQuote{atomic}
here to explicitly prohibit lists. Default is \code{NULL} (no check).}

\item{any.missing}{[\code{logical(1)}]\cr
Are missing values allowed? Default is \code{TRUE}.}

\item{all.missing}{[\code{logical(1)}]\cr
Are matrices with only missing values allowed? Default is \code{TRUE}.}

\item{min.rows}{[\code{integer(1)}]\cr
Minimum number of rows.}

\item{min.cols}{[\code{integer(1)}]\cr
Minimum number of columns.}

\item{nrows}{[\code{integer(1)}]\cr
Exact number of rows.}

\item{ncols}{[\code{integer(1)}]\cr
Exact number of columns.}

\item{row.names}{[\code{character(1)}]\cr
Check for row names. Default is \dQuote{NULL} (no check).
See \code{\link{checkNamed}} for possible values.
Note that you can use \code{\link{checkSubset}} to check for a specific set of names.}

\item{col.names}{[\code{character(1)}]\cr
Check for column names. Default is \dQuote{NULL} (no check).
See \code{\link{checkNamed}} for possible values.
Note that you can use \code{\link{checkSubset}} to test for a specific set of names.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertions. See \code{\link{AssertCollection}}.}

\item{.var.name}{[character(1)]\cr
Name for \code{x}. Defaults to a heuristic to determine
the name using \code{\link[base]{deparse}} and \code{\link[base]{substitute}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[character(1)]\cr
Same as \code{.var.name}, but passed down to \code{\link[testthat]{expect_that}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions return \code{TRUE}. If the check
 is not successful, \code{assertMatrix}/\code{assert_matrix}
 throws an error message, \code{testMatrix}/\code{test_matrix}
 returns \code{FALSE},
 and \code{checkMatrix} returns a string with the error message.
 The function \code{expect_matrix} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is a matrix
}
\examples{
x = matrix(1:9, 3)
colnames(x) = letters[1:3]
testMatrix(x, nrows = 3, min.cols = 1, col.names = "named")
}
\seealso{
Other basetypes: \code{\link{checkArray}},
  \code{\link{checkAtomicVector}},
  \code{\link{checkAtomic}}, \code{\link{checkCharacter}},
  \code{\link{checkComplex}}, \code{\link{checkDataFrame}},
  \code{\link{checkDataTable}},
  \code{\link{checkEnvironment}},
  \code{\link{checkFactor}}, \code{\link{checkFunction}},
  \code{\link{checkIntegerish}},
  \code{\link{checkInteger}}, \code{\link{checkList}},
  \code{\link{checkLogical}}, \code{\link{checkNumeric}},
  \code{\link{checkVector}}
}

