% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkScalar.R
\name{checkScalar}
\alias{checkScalar}
\alias{check_scalar}
\alias{assertScalar}
\alias{assert_scalar}
\alias{testScalar}
\alias{test_scalar}
\alias{expect_scalar}
\title{Check if an argument is a single atomic value}
\usage{
checkScalar(x, na.ok = FALSE, null.ok = FALSE)

check_scalar(x, na.ok = FALSE, null.ok = FALSE)

assertScalar(x, na.ok = FALSE, null.ok = FALSE, .var.name = vname(x),
  add = NULL)

assert_scalar(x, na.ok = FALSE, null.ok = FALSE, .var.name = vname(x),
  add = NULL)

testScalar(x, na.ok = FALSE, null.ok = FALSE)

test_scalar(x, na.ok = FALSE, null.ok = FALSE)

expect_scalar(x, na.ok = FALSE, null.ok = FALSE, info = NULL,
  label = vname(x))
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{na.ok}{[\code{logical(1)}]\cr
Are missing values allowed? Default is \code{FALSE}.}

\item{null.ok}{[\code{logical(1)}]\cr
If set to \code{TRUE}, \code{x} may also be \code{NULL}.
In this case only a type check of \code{x} is performed, all additional checks are disabled.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertScalar}/\code{assert_scalar} return 
 \code{x} invisibly, whereas
 \code{checkScalar}/\code{check_scalar} and 
 \code{testScalar}/\code{test_scalar} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertScalar}/\code{assert_scalar}
 throws an error message, 
 \code{testScalar}/\code{test_scalar}
 returns \code{FALSE},
 and \code{checkScalar} returns a string with the error message.
 The function \code{expect_scalar} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is a single atomic value
}
\details{
This function does not distinguish between
\code{NA}, \code{NA_integer_}, \code{NA_real_}, \code{NA_complex_}
\code{NA_character_} and \code{NaN}.
}
\examples{
testScalar(1)
testScalar(1:10)
}
\seealso{
Other scalars: \code{\link{checkCount}},
  \code{\link{checkFlag}}, \code{\link{checkInt}},
  \code{\link{checkNumber}}, \code{\link{checkScalarNA}},
  \code{\link{checkString}}
}
