% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_project_files.R
\name{scan_project_files}
\alias{scan_project_files}
\title{Scan R files for package dependencies}
\usage{
scan_project_files(
  project_dir = ".",
  scan_r_only = FALSE,
  scan_rnw_with_knitr = TRUE,
  scan_rprofile = TRUE
)
}
\arguments{
\item{project_dir}{A project path.  This is the path to the root of the project that references the packages to be installed from the MRAN snapshot for the date specified for \code{snapshotDate}. Defaults to the current working directory.}

\item{scan_r_only}{If \code{TRUE}, limits the scanning of project files to R scripts only (those with the extension \code{.R}).}

\item{scan_rnw_with_knitr}{If \code{TRUE}, scans Sweave files with \code{\link[knitr:knitr]{knitr::knitr}}, otherwise with \code{\link[utils:Stangle]{utils::Stangle}}. Ignored if \code{scan_r_only=TRUE}.}

\item{scan_rprofile}{if \code{TRUE}, includes the \verb{~/.Rprofile} startup file in the scan. See \code{\link{Startup}}.}
}
\value{
A list with 2 components: \code{pkgs}, a vector of package names, and \code{errors}, a vector of files that could not be scanned. The package listing includes third-party packages, as well as those that are distributed with R and have "Recommended" priority. Base-priority packages (utils, graphics, methods and so forth) are not included.

In addition, if any Rmarkdown files are found, the package listing will include rmarkdown. This allows you to continue rendering them in a checkpointed session.
}
\description{
This function scans the R files in your project, including scripts, Sweave documents and Rmarkdown-based files, for references to packages.
}
\details{
\code{scan_project_files} recursively builds a list of all the R files in your project. This includes regular R scripts, as well as Sweave files (those with extension \code{.Rnw}) and Rmarkdown-based files (those with extension \code{.Rmd}, \code{.Rpres} or \code{Rhtml}). It then parses the code in each file and looks for calls to \code{library} and \code{require}, as well as the namespacing operators \code{::} and \code{:::}. The detected packages are assumed to be available from CRAN/MRAN.
}
\section{Manifest}{


As an \strong{experimental feature}, you can specify additional packages to include or exclude via an optional \code{checkpoint.yml} manifest file located in your project directory. This should be a valid YAML file with 2 components:
\itemize{
\item \code{refs}: An array of package references to include in the checkpoint, that can be parsed by \code{\link[pkgdepends:new_pkg_installation_proposal]{pkgdepends::new_pkg_installation_proposal}}.
\item \code{exclude}: An array of package names (without decorations) to exclude from the checkpoint, despite showing up in the scan.
}

A manifest file allows you to include packages from sources other than CRAN/MRAN in the checkpoint. You can include a Bioconductor package with a \verb{bioc::} reference: \code{bioc::BiocGenerics}. A GitHub reference begins with \verb{github::}, for example \code{github::RevolutionAnalytics/checkpoint@v1.0}. A \verb{local::} reference can point to a package \code{.tar.gz} file, or to a directory containing the package source code.

You should use this feature with caution, as checkpoint does not check the versions of these packages. It's recommended that you include a version number, tag or commit hash in a reference, so that you always obtain the same version of the package. See \code{\link[pkgdepends:pkg_refs]{pkgdepends::pkg_refs}} for a full description of the reference syntax; note that \verb{installed::} references are \emph{not} currently supported by checkpoint.

A use case for exclusions is if your workflow loads packages that are not on CRAN or other public repositories. For example, Microsoft Machine Learning Server (MMLS) comes with a number of proprietary packages for big data and in-database analytics. You can exclude these packages from checkpointing by listing them in the \code{exclude} entry in the manifest. In this case, you must ensure that your packages are still visible to the checkpointed session, for example by specifying \code{prepend=TRUE} in the \code{use_checkpoint} call. If you share your project with collaborators, they will also need to have these packages separately installed on their machines.
}

\examples{
scan_project_files()
}
